#include <ImageSearch.au3>
#include <AutoItConstants.au3>

;  Check if the commandline has not less than or more than 8 commandline varialbles. If either of it happens a prompt will be generated with the commandline commands list and the script will exit.
If $CmdLine[0] < 9 OR $CmdLine[0] > 9 Then MsgBox(16,"Help info Find Image","Found " &$CmdLine[0]& " values, expected 8 see below for examples:" & @LF & "1. File name - C:\Capture.png" & @LF & "2. Timeout in seconds - 120" & @LF & "3. Tolerance - 1(very strict)-255(not strict)" & @LF & "4. Automatic Logoff no or yes - 0/1" & @LF & "5. Logoff wait timeout in seconds - 20" & @LF & "6. x axis mouse location if image can not be found (only works if Logoff is disabled) - 350" & @LF & "7. y axis mouse location if image can not be found" & @LF & "8. Click if find image no or yes or double click - 0/1/2" & @LF & "9. whether or not to produce messagebox at all if an image is not found")
If $CmdLine[0] < 9 Then Exit (1)
If $CmdLine[0] > 9 Then Exit (1)

; The 9 command line variables, cmdline 0 has the complete string.
$CmdLine[0] ; This contains 7 parameters.
$CmdLine[1] ; This contains The filename.png.
$CmdLine[2] ; This contains The timeout value.
$CmdLine[3] ; This contains The tolerance value, 0-255.
$CmdLine[4] ; This is the switch to enable or disable automatic logoff
$CmdLine[5] ; This is the amount of seconds to wait untill logoff
$CmdLine[6] ; This is the x axis location in pixels if image can not be found
$CmdLine[7] ; This is the y axis location in pixels if image can not be found
$CmdLine[8] ; This is whether or not to click on the image when it is found - no or yes or double click, 0/1/2
$CmdLine[9] ; This is whether or not to produce messagebox at all if an image is not found - no or yes - 0/1

; Local variables definition for the script
Local $filename = $CmdLine[1]
Local $timeout = $CmdLine[2]
Local $tolerance = $CmdLine[3]
Local $logoff = $CmdLine[4]
Local $logoffseconds = $CmdLine[5]
Local $x2 = $CmdLine[6]
Local $y2 = $CmdLine[7]
Local $click = $CmdLine[8]
Local $messagebox = $CmdLine[9]
Local $x1 = 0
Local $y1 = 0


; Check if the image exsist.
If FileExists ($filename) Then

   ; Search for the image
   $result = _WaitForImageSearch($filename,$timeout,1,$x1,$y1,$tolerance)

   ; If found move Mouse
   if $result = 1 Then
	MouseMove($x1,$y1,10)
	; If found then double click, after mouse move
	if $click = 2 Then
		MouseClick($MOUSE_CLICK_LEFT)
		MouseClick($MOUSE_CLICK_LEFT)
	EndIf
	; If found then single click, after mouse move
	if $click = 1 Then
		MouseClick($MOUSE_CLICK_LEFT)
	EndIf
	; If found then dont click, after mouse move
	if $click = 0 Then
		Sleep(1)
	EndIf
   EndIf
   

   ; If after the timeout the image can not be found a prompt is generated for x seconds
   if $result = 0 Then
	  if $messagebox = 1 Then
	  MsgBox(0,"Image Search","Did not find a match " & $filename & ". Waiting for " & $logoffseconds & " seconds untill logoff.", $logoffseconds)
	  Else
			sleep(1)
	  EndIf	

	  ;If logoff function is 0 the session is logged off
	  if $logoff = 1 Then
		 ShellExecute("cmd.exe","/c shutdown /l /f","C:\windows\system32")
	  EndIf

	  ;If logoff must not be triggered after error the mouse is moved to the following coordinates
	  if $logoff = 0 Then
		 MouseMove($x2,$y2,10)
	  EndIf
   EndIf

Else
		MsgBox(48,"Image Search", "No image called: " & $filename & " in " & @ScriptDir)
EndIf

