﻿// This file contains your Data Connector logic
section LoginEnterprise;

[DataSource.Kind="LoginEnterprise", Publish="LoginEnterprise.Publish"]
shared LoginEnterprise.apiURL = Value.ReplaceType(LoginEnterpriseImpl, type function (url as Uri.Type) as any);

token = Extension.CurrentCredential()[Key];

LoginEnterpriseImpl = (url as text) =>
    let
                Tests = Json.Document(Web.Contents(url, [RelativePath="tests", Query=[
                        orderBy="name", 
                        direction="ascending",
                        count="100",
                        include="none",
                        token=token
                    ]])),
                items = Tests[items],
    
                #"Tests Convert" = Table.FromList(items, Splitter.SplitByNothing(), null, null, ExtraValues.Error),
                #"Tests Expand" = Table.ExpandRecordColumn(#"Tests Convert", "Column1", 
                    {"$type", "numberOfSessions", "isEnabled", "id", "name", "description", "created",  "rampUpDurationInMinutes", "testDurationInMinutes", "rampDownDurationInMinutes", "state"}, 
                    {"testType", "testNumberOfSessions", "testIsEnabled", "testId", "testName", "testDescription", "testCreated", "testRampUpDurationInMinutes", "testDurationInMinutes", "testRampDownDurationInMinutes", "testState"}),

                #"TestRun Invoke" = Table.AddColumn(#"Tests Expand", "TestRun", each TestRun(url,[testId])),
                #"TestRun Expand" = Table.ExpandTableColumn(#"TestRun Invoke", "TestRun", {"Column1"}, {"Column1"}),
                #"TestRun Expand Columns" = Table.ExpandRecordColumn(#"TestRun Expand", "Column1", 
                    {"state", "result", "activeSessionCount", "productVersion", "loginCounts", "engineCounts", "appExecutionCounts", "appFailureResults", "appPerformanceResults", "id", "created", "started", "finished"},
                    {"testRunState", "testRunResult", "testRunActiveSessionCount", "testRunProductVersion", "testRunLoginCounts", "testRunEngineCounts", "testRunAppExecutionCounts", "testRunAppFailureResults", "testRunAppPerformanceResults", "testRunId", "testRunCreated", "testRunStarted", "testRunFinished"}),
                #"TestRun Expand.loginCounts" = Table.ExpandRecordColumn(#"TestRun Expand Columns", "testRunLoginCounts", {"successCount", "totalCount"}, {"testRunLoginCounts.successCount", "testRunLoginCounts.totalCount"}),
                #"TestRun Expand.engineCounts" = Table.ExpandRecordColumn(#"TestRun Expand.loginCounts", "testRunEngineCounts", {"successCount", "totalCount"}, {"testRunEngineCounts.successCount", "testRunEngineCounts.totalCount"}),
                #"TestRun Expand.appExecutionCounts" = Table.ExpandRecordColumn(#"TestRun Expand.engineCounts", "testRunAppExecutionCounts", {"successCount", "totalCount"}, {"testRunAppExecutionCounts.successCount", "testRunAppExecutionCounts.totalCount"}),
                #"TestRun Expand.appFailureResults" = Table.ExpandRecordColumn(#"TestRun Expand.appExecutionCounts", "testRunAppFailureResults", {"successCount", "totalCount"}, {"testRunAppFailureResults.successCount", "testRunAppFailureResults.totalCount"}),
                #"TestRun Expand.appPerformanceResults" = Table.ExpandRecordColumn(#"TestRun Expand.appFailureResults", "testRunAppPerformanceResults", {"successCount", "totalCount"}, {"testRunAppPerformanceResults.successCount", "testRunAppPerformanceResults.totalCount"}),
    
                #"Measurement Invoke" = Table.AddColumn(#"TestRun Expand.appPerformanceResults", "Measurements", each Measurement(url,[testRunId])),
                #"Measurements Expand" = Table.ExpandRecordColumn(#"Measurement Invoke", "Measurements", {"items"}, {"items"}),
                #"Measurements Expand Columns" = Table.ExpandListColumn(#"Measurements Expand", "items"),
                #"Measurements Expand to Rows" = Table.ExpandRecordColumn(#"Measurements Expand Columns", "items", 
                    {"measurementId", "applicationId", "launcherName", "duration", "timestamp"}, 
                    {"measurementId", "applicationId", "measurementLauncherName", "measurementDuration", "measurementTimestamp"}),
    
                #"Application Invoke" = Table.AddColumn(#"Measurements Expand to Rows", "Applications", each Application(url,[applicationId])),
                #"Applications Expand" = Table.ExpandRecordColumn(#"Application Invoke", "Applications", 
                    {"$type", "commandLine", "name", "description"}, 
                    {"applicationType", "applicationCommandLine", "applicationName", "applicationDescription"}),

                #"Changed Type" = Table.TransformColumnTypes(#"Applications Expand",{{"testType", type text}, {"testIsEnabled", type text}, {"testId", type text}, {"testName", type text}, {"testDescription", type text}, {"testState", type text}, {"testRunState", type text}, {"testRunResult", type text}, {"testRunId", type text}, {"measurementId", type text}, {"applicationId", type text}, {"measurementLauncherName", type text}, {"applicationType", type text}, {"applicationCommandLine", type text}, {"applicationName", type text}, {"applicationDescription", type text}, {"testNumberOfSessions", Int64.Type}, {"testRampUpDurationInMinutes", Int64.Type}, {"testDurationInMinutes", Int64.Type}, {"testRampDownDurationInMinutes", Int64.Type}, {"testRunActiveSessionCount", Int64.Type}, {"testRunLoginCounts.successCount", Int64.Type}, {"testRunLoginCounts.totalCount", Int64.Type}, {"testRunEngineCounts.successCount", Int64.Type}, {"testRunEngineCounts.totalCount", Int64.Type}, {"testRunAppExecutionCounts.successCount", Int64.Type}, {"testRunAppExecutionCounts.totalCount", Int64.Type}, {"testRunAppFailureResults.successCount", Int64.Type}, {"testRunAppFailureResults.totalCount", Int64.Type}, {"testRunAppPerformanceResults.successCount", Int64.Type}, {"testRunAppPerformanceResults.totalCount", Int64.Type}, {"measurementDuration", Int64.Type}, {"testRunProductVersion", type text}, {"testCreated", type datetime}, {"testRunCreated", type datetime}, {"testRunStarted", type datetime}, {"testRunFinished", type datetime}, {"measurementTimestamp", type datetime}})
in
    #"Changed Type";



TestRun = (url as text, testRunId as any) =>
try
    let
            TestRuns = Json.Document(Web.Contents(url, [RelativePath="/tests/" & testRunId &"/test-runs", Query=[
            direction="ascending", 
            count="50",
            include="none",
            token=token
            ]])),
            items2 = TestRuns[items],
            #"ConvertedTestRuns" = Table.FromList(items2, Splitter.SplitByNothing(), null, null, ExtraValues.Error)    
    in
        #"ConvertedTestRuns"
otherwise null;

Measurement = (url as text, testRunID as any) =>
try
    let
        Measurements = Json.Document(Web.Contents(url, [RelativePath="/test-runs/" & testRunID & "/measurements", Query=[
                    direction="ascending", 
                    count="50",
                    include="all",
                    token= token
                ]]))
    in
        Measurements
otherwise null;

Application = (url as text, applicationID as any) =>
try
let
    ApplicationDetails = Json.Document(Web.Contents(url, [RelativePath="/applications/" & applicationID & "/", Query=[
                include="all",
                token=token
            ]]))
in
    ApplicationDetails
otherwise null;

TestRunEvent = (url as text, TestRunID as any) =>
try
let
    TestRunEvents = Json.Document(Web.Contents(url, [RelativePath="/test-runs/" & TestRunID & "/events", Query=[
                count="100",
                include="all",
                token=token
            ]]))
in
    TestRunEvents
otherwise null;



// Data Source Kind description
LoginEnterprise = [
    // enable both OAuth and Key based auth
    Authentication = [
        Key = [
        ]
    ],
    Label = Extension.LoadString("DataSourceLabel")
];

// Data Source UI publishing description
LoginEnterprise.Publish = [
    Beta = false,
    Category = "Other",
    ButtonText =  { Extension.LoadString("ButtonTitle"), Extension.LoadString("ButtonHelp") },
    LearnMoreUrl = "https://www.loginvsi.com/",
    SourceImage = LoginEnterprise.Icons,
    SourceTypeImage = LoginEnterprise.Icons
];


LoginEnterprise.Icons = [
Icon16 = { Extension.Contents("LoginEnterprise16.png") ,Extension.Contents("LoginEnterprise20.png") ,Extension.Contents("LoginEnterprise24.png") ,Extension.Contents("LoginEnterprise32.png") },
Icon32 = { Extension.Contents("LoginEnterprise32.png") ,Extension.Contents("LoginEnterprise40.png") ,Extension.Contents("LoginEnterprise48.png") ,Extension.Contents("LoginEnterprise64.png") }
];
