using LoginPI.Engine.ScriptBase;

public class WordPad : ScriptBase{

    private void Execute(){
        START();
        //Opens / Starts the application
        //Make sure it is in caps
        
        FindWindow(className : "Win32 Window:WordPadClass", title : "Document - WordPad", processName : "wordpad").Focus();
        // Check if the window where we are going to type exists

        MainWindow.FindControl(className : "Document:RICHEDIT50W", title : "Rich Text Window").Type("Hello, World!");
        // type to the specifc control

        MainWindow.FindControl(className : "Document:RICHEDIT50W", title : "Rich Text Window").Type("{ctrl+s}");
        // Send a ctrl s action to wordpad    

        var mysavedialog = FindWindow(className : "Win32 Window:#32770", title : "Save As", processName : "wordpad", timeout:1).Focus();
        // create the variable mysavedialog with a findwindow action

        mysavedialog.FindControl(className : "Edit:Edit", title : "File name:").Type("My First Save.rtf");
        // find the file name text box in the mysavedialog variable

        mysavedialog.FindControl(className : "Button:Button", title : "&Save").Click();
        // find the save button in the mysavedialog variable

        var ConfirmSaveDialog = FindWindow(className : "Win32 Window:#32770", title : "Confirm Save As", processName : "wordpad", timeout:1, continueOnError:true);
        if (ConfirmSaveDialog != null){
            ConfirmSaveDialog.FindControl(className : "Button:CCPushButton", title : "&Yes").Click();
        }
        // saving the file if file already exists

        Wait(5);
        // Waits for 5 seconds until going to the next action

        MainWindow.FindControl(className : "Document:RICHEDIT50W", title : "Rich Text Window").Type("{ctrl+o}");        
        var OpenFileDialog = FindWindow(className : "Win32 Window:#32770", title : "Open", processName : "wordpad", timeout:5, continueOnError:true);
        OpenFileDialog.FindControl(className : "Edit:Edit", title : "File name:").Type("Existing File.rtf");
        OpenFileDialog.FindControl(className : "Button:Button", title : "&Open").Click();
        
        // Opening a file that exists

        var ErrorDialog = OpenFileDialog.FindControl(className : "Win32 Window:#32770", title : "Open", timeout:1, continueOnError:true);
        
        if (ErrorDialog != null)
        {
            ErrorDialog.FindControl(className : "Button:CCPushButton", title : "OK").Click();
            OpenFileDialog.FindControl(className : "Button:Button", title : "Cancel").Click();
            
        }

        else
        {
            FindWindow(className : "Win32 Window:WordPadClass", title : "Existing File*", processName : "wordpad");
        }

        FindWindow(className : "Win32 Window:WordPadClass", title : "*WordPad", processName : "wordpad");
        // Opening a file that does not exist
        
        Wait(5);

        StartTimer(name:"Print_Sequence");
        StartTimer(name:"Print_Window");
        MainWindow.FindControl(className : "Document:RICHEDIT50W", title : "Rich Text Window").Type("{ctrl+P}");
        
        var PrintDialog = FindWindow(className : "Win32 Window:#32770", title : "Print", processName : "wordpad", timeout:1, continueOnError:true);
        
        if (PrintDialog != null){
            StopTimer(name:"Print_Window");
            var PrinterExists = PrintDialog.FindControl(className : "ListItem", title : "Microsoft Print to PDF", timeout:1, continueOnError:true);
            
            if (PrinterExists != null)
            {
                PrintDialog.FindControl(className : "ListItem", title : "Microsoft Print to PDF").Click();

                StartTimer(name:"Save_Print_Output_Window");
                PrintDialog.FindControl(className : "Button:Button", title : "&Print").Click();

                var SavePrintAs = FindWindow(className : "Win32 Window:#32770", title : "Save Print Output As", processName : "wordpad", timeout:3, continueOnError:true);

                if (SavePrintAs != null)
                {
                    StopTimer(name:"Save_Print_Output_Window");

                    SavePrintAs.FindControl(className : "Edit:Edit", title : "File name:").Type("My First PDF.pdf");
                    SavePrintAs.FindControl(className : "Button:Button", title : "&Save").Click();
                    
                    var ConfirmSavePDF = FindWindow(className : "Win32 Window:#32770", title : "Confirm Save As", processName : "wordpad", timeout:1, continueOnError:true);
                    if (ConfirmSavePDF != null)
                    {
                        ConfirmSavePDF.FindControl(className : "Button:CCPushButton", title : "&Yes").Click();
                    }
                }
                else
                {
                    PrintDialog.Close();
                    CancelTimer(name:"Save_Print_Output_Window");
                }

            }
        
            else
            { 
                PrintDialog.Close();
                CancelTimer(name:"Print_Sequence");
                CancelTimer(name:"Print_Window");
            }

        }
        StopTimer(name:"Print_Sequence");

        FindWindow(className : "Win32 Window:WordPadClass", title : "Existing File*", processName : "wordpad").Focus();
        // Printing to PDF

        Wait(5);
        // Waits for 5 seconds until going to the next action

        STOP();
        //Stops / closes the application
        //Make sure it is in caps
    }

}